require( "HiddenObject/script/style.lua" );

HeaderFont = {
  standardFont,
  30,
  WhiteColor
};

TextFont = {
  standardFont,
  28,
  Color(204, 198, 183, 255)
};

ButtonFont = {
  standardFont,
  18,
  Color(173,193,161,255)
};

FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	font = ButtonFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

DialogTitleText = 
{
	parent=DefaultStyle,
	font = HeaderFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=42
};

DialogBodyText =
 {
	parent=DefaultStyle,
	font =TextFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};



function GetWindowX()

	x = kCenter;
	if gSplashQuitFlag then x = kCenter; end
	if IsMainMenu() then x = 342; end
	return x;
end



function GetWindowY()

	y = kCenter - 45;
	if IsMainMenu() then y = 160; end
	if gSplashQuitFlag then y = kCenter; end
	return y;
end


MakeDialog
{
	name="quitVerifyDialog", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="HiddenObject/UI/Background/dialog",
		--x = GetWindowX(),
		--y = GetWindowY(),
		x = 342,
		y = 160,
		SetStyle(DialogTitleText),
		Text
		{
			--flags = kVAlignTop + kHAlignCenter,
			x = 10,
			y = 20;
            font = StandardHeaderFont,
			name = "quittitle",
			label= "quittitle",
		};
		
		SetStyle(DialogBodyText),
		Text
		{
			-- flags = kVAlignCenter + kHAlignCenter,
			name = "quitconfirm",
			label= "quitconfirm",
		};
		
        SetStyle(FooterStyle),
        Button
        {
			command=
				function()
					PostMessage( CreateNamedMessage( kQuitNow, "quit" ) );
				end;
            flags = 5,
            label = "yes",
            font = StandardButtonFont,
            name = "yes",
            x = kCenter-80,
            y = -80,
        },
        Button
        {
			command=
				function() 
					PopModal('quitVerifyDialog');
                end;
            flags = 5,
            label = "no",
            font = StandardButtonFont,
            name = "no",
            x = kCenter+80,
            y = -80,
        },
        
    },

} -- MakeDialog
